//
//  CQAdNativeAdDemoViewController.m
//  CQAdDemo
//
//  Created by hanxiaoyu on 2022/5/10.
//

#import "CQAdNativeAdDemoViewController.h"
#import <CQAdSDK/CQAdSDK.h>

@interface CQAdNativeAdCell : UITableViewCell

@property (nonatomic, strong) UIImageView *imgView;
@property (nonatomic, strong) UILabel *adTitleLabel;
@property (nonatomic, strong) UILabel *adDescriptionLabel;
@property (nonatomic, strong) UIImageView *sdkLogo;
@property (nonatomic, strong) UILabel *adTag;

@end

@implementation CQAdNativeAdCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        [self buildupView];
    }
    return self;
}

-(void)buildupView
{
    CGFloat width = [UIScreen mainScreen].bounds.size.width;
        
    self.imgView = [[UIImageView alloc] init];
    self.imgView.frame = CGRectMake(width / 2, 0, width / 2, 120);
    [self.contentView addSubview:self.imgView];
    
    self.adTitleLabel = [UILabel new];
    self.adTitleLabel.frame = CGRectMake(12, 12, width / 2 - 12, 48);
    self.adTitleLabel.numberOfLines = 2;
    self.adTitleLabel.textAlignment = NSTextAlignmentLeft;
    [self.contentView addSubview:self.adTitleLabel];
    
    self.adDescriptionLabel = [UILabel new];
    self.adDescriptionLabel.frame = CGRectMake(12, 88, width / 2 - 12, 20);
    self.adDescriptionLabel.numberOfLines = 0;
    self.adDescriptionLabel.font = [UIFont systemFontOfSize:14];
    [self.contentView addSubview:self.adDescriptionLabel];

    self.sdkLogo = [UIImageView new];
    self.sdkLogo.frame = CGRectMake(width - 80, 90, 14, 14);
    [self.contentView addSubview:self.sdkLogo];
    
    self.adTag = [UILabel new];
    self.adTag.frame = CGRectMake(width - 60, 90, 50, 14);
    self.adTag.text = @"广告";
    self.adTag.font = [UIFont systemFontOfSize:12];
    self.adTag.textColor = [UIColor whiteColor];
    [self.contentView addSubview:self.adTag];

}

@end


@interface CQAdNativeAdDemoViewController ()<CQNativeAdsManagerDelegate,CQNativeAdDelegate,UITableViewDelegate, UITableViewDataSource>

@property (nonatomic) CQNativeAdsManager* nativeAdsManager;

@property (nonatomic, strong) UITableView* tableView;

@property (nonatomic, strong) NSMutableArray* dataArray;
@end

@implementation CQAdNativeAdDemoViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupViews];
    
    [self loadNativeAd];
}

- (void)setupViews
{
    self.view.backgroundColor = UIColor.grayColor;
    
    self.dataArray = NSMutableArray.new;
    for(NSInteger i=0; i<15; i++)
    {
        [self.dataArray addObject:[NSString stringWithFormat:@"data row %@", @(i)]];
    }
    
    self.tableView = [[UITableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain];
    [self.view addSubview:self.tableView];
    
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    
    [self.tableView registerClass:[CQAdNativeAdCell class] forCellReuseIdentifier:@"adRowIdentifier"];

}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataArray.count;
}

- (UITableViewCell*)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    id data = self.dataArray[indexPath.row];
    if([data isKindOfClass:CQNativeAd.class])
    {
        CQNativeAd* nativeAd = (CQNativeAd*)data;
        
        CQAdNativeAdCell * cell = [tableView dequeueReusableCellWithIdentifier:@"adRowIdentifier"];
        if(!cell)
        {
            cell = [[CQAdNativeAdCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"adRowIdentifier"];
        }
        
        NSData *data = [NSData dataWithContentsOfURL:[NSURL URLWithString:nativeAd.data.adImage]];
        UIImage *image = [UIImage imageWithData: data];
        cell.imgView.image = image;
        
        data = [NSData dataWithContentsOfURL:[NSURL URLWithString:nativeAd.data.sdkLogo]];
        image = [UIImage imageWithData: data];
        cell.sdkLogo.image = image;

        cell.adTitleLabel.text = nativeAd.data.adTitle;
        cell.adDescriptionLabel.text = nativeAd.data.adDescription;
        
        if (nativeAd.data.adMode == CQNativeAdModeVideo) {
            nativeAd.mediaView.frame = cell.imgView.bounds;
            [cell.imgView addSubview:nativeAd.mediaView];
            
            [nativeAd reSizeMediaView];
        }
        
        [nativeAd registerContainer:cell.contentView withClickableViews:@[cell.contentView]];
        
        return cell;
    }
    else
    {
        UITableViewCell* cell = [tableView dequeueReusableCellWithIdentifier:@"normalDataRowIdentifier"];
        if(!cell)
        {
            cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"normalDataRowIdentifier"];
        }
        cell.contentView.backgroundColor = (indexPath.row % 2) ? UIColor.redColor : UIColor.grayColor;
        return cell;
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    id data = self.dataArray[indexPath.row];
    if([data isKindOfClass:CQNativeAd.class])
    {
        return 120;
    }
    return 30;

}

//======================================================================
//百度广告要求上报 展示 事件。（如果明确后台不配置百度信息流广告，可以不调用此方法

- (void)scrollViewDidEndDragging:(UIScrollView *)scrollView willDecelerate:(BOOL)decelerate
{
    if (!decelerate)
    {
        [self checkAdViewImpression];
    }
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView
{
    [self checkAdViewImpression];
}

-(void)tableView:(UITableView *)tableView didEndDisplayingCell:(UITableViewCell *)cell forRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self trackImpressionRow:indexPath];
}

- (void)checkAdViewImpression
{
    NSArray *visiblePath = [self.tableView indexPathsForVisibleRows];
    for (NSIndexPath *visible in visiblePath)
    {
        [self trackImpressionRow:visible];
    }
}

- (void)trackImpressionRow:(NSIndexPath *)indexPath
{
    if(indexPath.row >= 0 && indexPath.row < self.dataArray.count)
    {
        id data = [self.dataArray objectAtIndex:indexPath.row];
        if([data isKindOfClass:CQNativeAd.class])
        {
            CQNativeAd* nativeAd = (CQNativeAd*)data;
            
            UIView *view = [self.tableView cellForRowAtIndexPath:indexPath];
            [nativeAd trackImpression:view];
        }
    }
}

//======================================================================

- (void)loadNativeAd
{
    self.nativeAdsManager = [[CQNativeAdsManager alloc] initWithPlacementId:@"2000015486" viewController:self];
    self.nativeAdsManager.delegate = self;
    [self.nativeAdsManager loadAds:3];
}

#pragma mark ExpressFeedAd delegate
-(void)cqNativeAdsManagerSuccessToLoad:(CQNativeAdsManager *)adsManager nativeAds:(NSArray<CQNativeAd *> *)nativeAdArray
{
    NSLog(@"CQAdNativeFeedAd:cqNativeAdsManagerSuccessToLoad");
    
    for (CQNativeAd *nativeAd in nativeAdArray) {
        nativeAd.delegate = self;
        
        if(self.dataArray.count > 0)
        {
            [self.dataArray insertObject:nativeAd atIndex:(arc4random() % self.dataArray.count)];
        }
        else
        {
            [self.dataArray addObject:nativeAd];
        }
    }
    [self.tableView reloadData];

}

-(void)cqNativeAdsManager:(CQNativeAdsManager *)adsManager didFailWithError:(NSError *)error
{
    NSLog(@"CQAdNativeFeedAd:didFailWithError");
}


/// 广告展示回调，不区分模板与非模板
/// @param nativeAd 广告对象
- (void)cqNativeAdDidBecomeVisible:(CQNativeAd *)nativeAd
{
    NSLog(@"cqNativeAdDidBecomeVisible");
}

/// 广告点击事件回调
/// @param nativeAd 广告对象
- (void)cqNativeAdDidClick:(CQNativeAd *)nativeAd
{
    NSLog(@"cqNativeAdDidClick");
}

/// 广告即将展示全屏页面/商店时触发
/// @param nativeAd 广告对象
- (void)cqNativeAdViewWillPresentFullScreenModal:(CQNativeAd *)nativeAd
{
    NSLog(@"cqNativeAdViewWillPresentFullScreenModal");
}


@end
